/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.schematics;

import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomRegisters;
import noppes.npcs.LogWriter;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.controllers.SchematicController;
import noppes.npcs.schematics.ISchematic;
import noppes.npcs.schematics.SchematicWrapper;
import noppes.npcs.util.Util;

public class Schematic
implements ISchematic {
    public short[] blockIdsArray = new short[0];
    public byte[] blockMetadataArray = new byte[0];
    public NBTTagList tileList = new NBTTagList();
    public NBTTagList entityList = new NBTTagList();
    public short height = 0;
    public short length = 0;
    public short width = 0;
    public String name;
    public BlockPos offset = BlockPos.field_177992_a;

    public static Schematic create(World world, EnumFacing fase, String name, Map<Integer, BlockPos> schMap) {
        BlockPos p = schMap.get(0);
        BlockPos m = schMap.get(1);
        BlockPos n = schMap.get(2);
        AxisAlignedBB bb = new AxisAlignedBB(m, n);
        short height = (short)(Math.abs(bb.field_72337_e - bb.field_72338_b) + 1.0);
        short width = (short)(Math.abs(bb.field_72336_d - bb.field_72340_a) + 1.0);
        short length = (short)(Math.abs(bb.field_72334_f - bb.field_72339_c) + 1.0);
        BlockPos pos = new BlockPos(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c);
        Schematic schema = new Schematic(name);
        schema.height = height;
        schema.width = fase == EnumFacing.EAST || fase == EnumFacing.WEST ? length : width;
        schema.length = fase == EnumFacing.EAST || fase == EnumFacing.WEST ? width : length;
        int size = height * width * length;
        schema.blockIdsArray = new short[size];
        schema.blockMetadataArray = new byte[size];
        int rot = 0;
        switch (fase) {
            case EAST: {
                rot = 1;
                break;
            }
            case NORTH: {
                rot = 2;
                break;
            }
            case WEST: {
                rot = 3;
                break;
            }
        }
        for (int i = 0; i < size; ++i) {
            int z;
            int x;
            int y = i / (width * length);
            switch (fase) {
                case EAST: {
                    x = i / length - y * width;
                    z = length - 1 - i % length;
                    break;
                }
                case NORTH: {
                    x = width - 1 - i % width;
                    z = length - 1 - i / width % length;
                    break;
                }
                case WEST: {
                    x = width - 1 - i / length % width;
                    z = i % length;
                    break;
                }
                default: {
                    x = i % width;
                    z = (i - x) / width % length;
                }
            }
            IBlockState state = SchematicWrapper.rotationState(world.func_180495_p(pos.func_177982_a(x, y, z)), rot);
            schema.blockIdsArray[i] = (short)Block.field_149771_c.func_148757_b((Object)state.func_177230_c());
            schema.blockMetadataArray[i] = (byte)state.func_177230_c().func_176201_c(state);
            if (!(state.func_177230_c() instanceof ITileEntityProvider)) continue;
            TileEntity tile = world.func_175625_s(pos.func_177982_a(x, y, z));
            NBTTagCompound nbtTile = new NBTTagCompound();
            if (tile != null) {
                tile.func_189515_b(nbtTile);
                int newX = i % schema.width;
                int newZ = (i - newX) / schema.width % schema.length;
                nbtTile.func_74768_a("x", newX);
                nbtTile.func_74768_a("y", y);
                nbtTile.func_74768_a("z", newZ);
            }
            schema.tileList.func_74742_a((NBTBase)nbtTile);
        }
        schema.offset = new BlockPos(bb.field_72340_a - (double)p.func_177958_n(), (double)(1 + (int)(bb.field_72338_b - (double)p.func_177956_o())), (double)((int)(bb.field_72339_c - (double)p.func_177952_p())));
        switch (fase) {
            case EAST: {
                schema.offset = new BlockPos((double)p.func_177952_p() - bb.field_72334_f, (double)((int)(bb.field_72338_b - (double)p.func_177956_o())), (double)((int)(bb.field_72340_a - (double)p.func_177958_n())));
                break;
            }
            case NORTH: {
                schema.offset = new BlockPos((double)p.func_177958_n() - bb.field_72336_d, (double)((int)(bb.field_72338_b - (double)p.func_177956_o())), (double)((int)((double)p.func_177952_p() - bb.field_72334_f)));
                break;
            }
            case WEST: {
                schema.offset = new BlockPos(bb.field_72339_c - (double)p.func_177952_p(), (double)((int)(bb.field_72338_b - (double)p.func_177956_o())), (double)((int)((double)p.func_177958_n() - bb.field_72336_d)));
                break;
            }
            default: {
                schema.offset = new BlockPos(bb.field_72340_a - (double)p.func_177958_n(), (double)((int)(bb.field_72338_b - (double)p.func_177956_o())), (double)((int)(bb.field_72339_c - (double)p.func_177952_p())));
            }
        }
        schema.entityList = new NBTTagList();
        AxisAlignedBB bbE = new AxisAlignedBB(bb.field_72340_a - 0.25, bb.field_72338_b - 0.25, bb.field_72339_c - 0.25, bb.field_72336_d + 0.25, bb.field_72337_e + 0.25, bb.field_72334_f + 0.25);
        List list = new ArrayList();
        try {
            list = world.func_72872_a(Entity.class, bbE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Entity e : list) {
            if (e instanceof EntityThrowable || e instanceof EntityArrow || e instanceof EntityPlayer) continue;
            NBTTagCompound nbtEntity = new NBTTagCompound();
            if (!e.func_184198_c(nbtEntity)) {
                nbtEntity = e.func_189511_e(new NBTTagCompound());
                ResourceLocation regName = EntityList.func_191301_a((Entity)e);
                if (regName == null) continue;
                nbtEntity.func_74778_a("id", regName.toString());
            }
            if (!nbtEntity.func_150297_b("UUID", 8)) {
                nbtEntity.func_74778_a("UUID", e.func_110124_au().toString());
            }
            NBTTagList posList = new NBTTagList();
            double[] d = new double[]{e.field_70165_t - (double)p.func_177958_n() - 1.0, e.field_70163_u - (double)p.func_177956_o(), e.field_70161_v - (double)p.func_177952_p() - 1.0};
            double[] ed = new double[]{d[0], d[1], d[2]};
            if (e instanceof EntityHanging) {
                d = new double[]{e.func_180425_c().func_177958_n() - p.func_177958_n(), e.func_180425_c().func_177956_o() - 1 - p.func_177956_o(), e.func_180425_c().func_177952_p() - p.func_177952_p()};
                ed = new double[]{d[0], d[1], d[2]};
                float er = nbtEntity.func_150295_c("Rotation", 5).func_150308_e(0);
                byte f = nbtEntity.func_74771_c("Facing");
                switch (rot) {
                    case 1: {
                        f = (byte)(f + 1);
                        er += 90.0f;
                        ed[0] = d[2];
                        ed[2] = d[0];
                        break;
                    }
                    case 2: {
                        f = (byte)(f + 2);
                        er += 180.0f;
                        ed[0] = ed[0] * -1.0;
                        ed[2] = ed[2] * -1.0;
                        break;
                    }
                    case 3: {
                        f = (byte)(f + 3);
                        er += 270.0f;
                        ed[0] = d[2] * -1.0;
                        ed[2] = d[0] * -1.0;
                        break;
                    }
                }
                f = (byte)(f % 4);
                nbtEntity.func_74774_a("Facing", f);
                nbtEntity.func_150295_c("Rotation", 5).func_150304_a(0, (NBTBase)new NBTTagFloat(er % 360.0f));
                nbtEntity.func_74768_a("TileX", (int)ed[0]);
                nbtEntity.func_74768_a("TileY", (int)ed[1]);
                nbtEntity.func_74768_a("TileZ", (int)ed[2]);
                posList.func_74742_a((NBTBase)new NBTTagDouble(ed[0]));
                posList.func_74742_a((NBTBase)new NBTTagDouble(ed[1]));
                posList.func_74742_a((NBTBase)new NBTTagDouble(ed[2]));
            } else {
                switch (rot) {
                    case 1: {
                        ed[0] = d[2];
                        ed[2] = d[0];
                        break;
                    }
                    case 2: {
                        ed[0] = ed[0] * -1.0;
                        ed[0] = ed[0] - 1.0;
                        ed[2] = ed[2] * -1.0;
                        ed[2] = ed[2] - 1.0;
                        break;
                    }
                    case 3: {
                        ed[0] = d[2] * -1.0;
                        ed[0] = ed[0] - 1.0;
                        ed[2] = d[0] * -1.0;
                        ed[2] = ed[2] - 1.0;
                        break;
                    }
                }
                posList.func_74742_a((NBTBase)new NBTTagDouble(ed[0] - 0.5));
                posList.func_74742_a((NBTBase)new NBTTagDouble(ed[1]));
                posList.func_74742_a((NBTBase)new NBTTagDouble(ed[2] - 0.5));
            }
            nbtEntity.func_74782_a("Pos", (NBTBase)posList);
            schema.entityList.func_74742_a((NBTBase)nbtEntity);
        }
        return schema;
    }

    public static Schematic create(World world, String name, BlockPos pos, short height, short width, short length) {
        Schematic schema = new Schematic(name);
        schema.offset = BlockPos.field_177992_a;
        schema.height = height;
        schema.width = width;
        schema.length = length;
        int size = height * width * length;
        schema.blockIdsArray = new short[size];
        schema.blockMetadataArray = new byte[size];
        TextComponentString message = new TextComponentString("Creating schematic at: " + pos + " might lag slightly");
        message.func_150256_b().func_150238_a(TextFormatting.GRAY);
        NoppesUtilServer.NotifyOPs((ITextComponent)message, false);
        schema.tileList = new NBTTagList();
        for (int i = 0; i < size; ++i) {
            int x = i % width;
            int z = (i - x) / width % length;
            int y = ((i - x) / width - z) / length;
            IBlockState state = world.func_180495_p(pos.func_177982_a(x, y, z));
            if (state.func_177230_c() == Blocks.field_150350_a || state.func_177230_c() == CustomRegisters.copy) continue;
            schema.blockIdsArray[i] = (short)Block.field_149771_c.func_148757_b((Object)state.func_177230_c());
            schema.blockMetadataArray[i] = (byte)state.func_177230_c().func_176201_c(state);
            if (!(state.func_177230_c() instanceof ITileEntityProvider)) continue;
            TileEntity tile = world.func_175625_s(pos.func_177982_a(x, y, z));
            NBTTagCompound compound = new NBTTagCompound();
            assert (tile != null);
            tile.func_189515_b(compound);
            compound.func_74768_a("x", x);
            compound.func_74768_a("y", y);
            compound.func_74768_a("z", z);
            schema.tileList.func_74742_a((NBTBase)compound);
        }
        return schema;
    }

    public Schematic(String name) {
        this.name = name;
    }

    public boolean equals(Object obj) {
        int i;
        if (!(obj instanceof Schematic)) {
            return false;
        }
        Schematic s = (Schematic)obj;
        if (!this.name.equals(s.name) || this.height != s.height || this.length != s.length || this.width != s.width || !this.offset.equals((Object)s.offset) || this.blockIdsArray.length != s.blockIdsArray.length || this.blockMetadataArray.length != s.blockMetadataArray.length || this.tileList.func_74745_c() != s.tileList.func_74745_c() || this.entityList.func_74745_c() != s.entityList.func_74745_c()) {
            return false;
        }
        for (i = 0; i < this.blockIdsArray.length; ++i) {
            if (this.blockIdsArray[i] == s.blockIdsArray[i]) continue;
            return false;
        }
        for (i = 0; i < this.blockMetadataArray.length; ++i) {
            if (this.blockMetadataArray[i] == s.blockMetadataArray[i]) continue;
            return false;
        }
        for (i = 0; i < this.tileList.func_74745_c(); ++i) {
            if (this.tileList.func_150305_b(i).equals((Object)s.tileList.func_150305_b(i))) continue;
            return false;
        }
        for (i = 0; i < this.entityList.func_74745_c(); ++i) {
            if (this.entityList.func_150305_b(i).equals((Object)s.entityList.func_150305_b(i))) continue;
            return false;
        }
        return true;
    }

    public byte[][] getBlockBytes() {
        byte[] blocks = new byte[this.blockIdsArray.length];
        byte[] addBlocks = null;
        for (int i = 0; i < blocks.length; ++i) {
            short id = this.blockIdsArray[i];
            if (id > 255) {
                if (addBlocks == null) {
                    addBlocks = new byte[(blocks.length >> 1) + 1];
                }
                addBlocks[i >> 1] = (i & 1) == 0 ? (byte)(addBlocks[i >> 1] & 0xF0 | id >> 8 & 0xF) : (byte)(addBlocks[i >> 1] & 0xF | (id >> 8 & 0xF) << 4);
            }
            blocks[i] = (byte)id;
        }
        if (addBlocks == null) {
            return new byte[][]{blocks};
        }
        return new byte[][]{blocks, addBlocks};
    }

    @Override
    public IBlockState getBlockState(int i) {
        Block b = Block.func_149729_e((int)this.blockIdsArray[i]);
        if (i < b.func_176194_O().func_177619_a().size()) {
            return (IBlockState)b.func_176194_O().func_177619_a().get(i);
        }
        return b.func_176203_a((int)this.blockMetadataArray[i]);
    }

    @Override
    public IBlockState getBlockState(int x, int y, int z) {
        int i = this.xyzToIndex(x, y, z);
        Block b = Block.func_149729_e((int)this.blockIdsArray[i]);
        return b.func_176203_a((int)this.blockMetadataArray[i]);
    }

    @Override
    public NBTTagList getEntitys() {
        return this.entityList;
    }

    @Override
    public short getHeight() {
        return this.height;
    }

    @Override
    public short getLength() {
        return this.length;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public NBTTagCompound getNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74777_a("Width", this.width);
        compound.func_74777_a("Height", this.height);
        compound.func_74777_a("Length", this.length);
        byte[][] arr = this.getBlockBytes();
        compound.func_74773_a("Blocks", arr[0]);
        if (arr.length > 1) {
            compound.func_74773_a("AddBlocks", arr[1]);
        }
        compound.func_74773_a("Data", this.blockMetadataArray);
        compound.func_74782_a("TileEntities", (NBTBase)this.tileList);
        compound.func_74782_a("Entities", (NBTBase)this.entityList);
        compound.func_74783_a("Offset", new int[]{this.offset.func_177958_n(), this.offset.func_177956_o(), this.offset.func_177952_p()});
        compound.func_74778_a("Name", this.name);
        return compound;
    }

    @Override
    public BlockPos getOffset() {
        return this.offset;
    }

    @Override
    public NBTTagCompound getTileEntity(int i) {
        return this.tileList.func_150305_b(i);
    }

    @Override
    public int getTileEntitySize() {
        if (this.tileList == null) {
            return 0;
        }
        return this.tileList.func_74745_c();
    }

    @Override
    public short getWidth() {
        return this.width;
    }

    @Override
    public boolean hasEntitys() {
        return this.entityList != null && this.entityList.func_74745_c() > 0;
    }

    public void load(NBTTagCompound compound) {
        this.width = compound.func_74765_d("Width");
        this.height = compound.func_74765_d("Height");
        this.length = compound.func_74765_d("Length");
        byte[] addId = compound.func_74764_b("AddBlocks") ? compound.func_74770_j("AddBlocks") : new byte[]{};
        this.setBlockBytes(compound.func_74770_j("Blocks"), addId);
        this.blockMetadataArray = compound.func_74770_j("Data");
        this.tileList = compound.func_150295_c("TileEntities", 10);
        this.entityList = compound.func_150295_c("Entities", 10);
        int[] arr = compound.func_74759_k("Offset");
        this.offset = arr.length >= 3 ? new BlockPos(arr[0], arr[1], arr[2]) : BlockPos.field_177992_a;
        if (!compound.func_74779_i("Name").isEmpty()) {
            this.name = compound.func_74779_i("Name");
        }
    }

    public void save(EntityPlayer player) {
        if (player == null || player.field_70170_p == null || !player.field_70170_p.field_72995_K) {
            return;
        }
        try {
            File file = new File(SchematicController.getDir(), this.name);
            CompressedStreamTools.func_74799_a((NBTTagCompound)this.getNBT(), (OutputStream)Files.newOutputStream(file.toPath(), new OpenOption[0]));
            TextComponentString component = new TextComponentString("Save Schematic file: \"" + file + "\"");
            component.func_150256_b().func_150238_a(TextFormatting.GRAY);
            player.func_145747_a((ITextComponent)component);
            if (SchematicController.Instance.map.containsKey(this.name)) {
                SchematicController.Instance.map.put(this.name, new SchematicWrapper(this));
            }
            if (CustomNpcs.VerboseDebug) {
                file = new File(SchematicController.getDir(), this.name.replace(".schematic", "") + ".json");
                Util.instance.saveFile(file, this.getNBT());
            }
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
    }

    public void setBlockBytes(byte[] blockId, byte[] addId) {
        this.blockIdsArray = new short[blockId.length];
        for (int index = 0; index < blockId.length; ++index) {
            short id = (short)(blockId[index] & 0xFF);
            if (index >> 1 < addId.length) {
                id = (index & 1) == 0 ? (short)(id + (short)((addId[index >> 1] & 0xF) << 8)) : (short)(id + (short)((addId[index >> 1] & 0xF0) << 4));
            }
            this.blockIdsArray[index] = id;
        }
    }

    public int xyzToIndex(int x, int y, int z) {
        return (y * this.length + z) * this.width + x;
    }
}

